--- Handles asking for sex with players and NPCs
-- @author QueuedResonance 2022, SolarEdge 2024 - 2025

ZLMain = {};

local ZomboWin = require("ZomboWin/ZomboWin");
local ZomboWinActType = ZomboWinActType;
require("ZomboWin/ZomboWinAnimationUtils")
require("ZomboWin/Temptation");
require("ZomboWin/zombieUpdate");

local ISWorldObjectContextMenu = ISWorldObjectContextMenu
local ISContextMenu = ISContextMenu
local ISToolTip = ISToolTip

local getText = getText
local string = string

local banditsEnabled = false;
if getActivatedMods():contains("\\Bandits2") == true then
	banditsEnabled = true;
	require("Bandits/BanditUpdate");
	require("Bandits/Bandit");
	require("Bandits/BanditBrain");
	require("Bandits/ZombiePrograms");
	require("Bandits/BanditPrograms");
	require("Bandits/BanditUtils");
	require("Bandits/BanditPlayer");
	require("Bandits/ZombieActions");
end

local ListedPositions = { --- Add more if there will be more context menu options
	"Oral",
	"Intercourse",
	"Consent",
}

local mastPos = {
	"Quick", "Regular", "Relaxed",
}

local clothingHandler = {};
clothingHandler.checkPants = {"Underwear","UnderwearBottom","Pants","FullSuit",};

local pantsOnlyHandler = {};
pantsOnlyHandler.checkPants = {"Pants",};

function isWearingPants()
    local pp = getPlayer()
    local myClothes = pp:getWornItems()
    if myClothes then
        for i = myClothes:size(), 1, -1 do
            local wornItem = myClothes:get(i - 1)

            if wornItem then
                local item = wornItem:getItem()
                local location = wornItem:getLocation()
                if item:IsClothing() then
                    for v = 1, #pantsOnlyHandler.checkPants do
                        local bodyPart = pantsOnlyHandler.checkPants[v]

                        if location == bodyPart then
                            return true
                        end
                    end
                end
            end
        end
    end

    return false
end

function isBanditPrideful(bandit)
	local prideChance = (SandboxVars.ZomboWin.bPride);
	local player = getPlayer();
	if bandit == nil then print("prideCheck: bandit nil"); return; end
	local isMainHeroFemale = player:isFemale()
	local isBanditFemale = bandit:isFemale();
	
	--- future update: nonbisex
	if isMainHeroFemale and not isBanditFemale then
		--print("pride: straight");
		return true;
	end
	
	--- future update: nonbisex
	if not isMainHeroFemale and isBanditFemale then
		--print("pride: straight");
		return true;
	end
	
	if isMainHeroFemale and isBanditFemale then
		--print("pride: no FxF animation available");
		return false;
	end
	
	if not isMainHeroFemale and not isBanditFemale then
		if prideChance == 1 then return false; end
		if not player:HasTrait("bisex") then print("pride: not gay"); return false; end
		local isPrideCheck = bandit:getModData().isPrideCheck;
		local isPrideful = bandit:getModData().isPrideful;
		
		if isPrideCheck then ---previously determined, no further actions needed
			if not isPrideful then 
				--print("bandit is not prideful");
				return false; 
			else 
				--print("bandit is prideful");
				return true; 
			end
		end
		bandit:getModData().isPrideCheck = true;
		
		local roll = ZombRand(100)
		if (prideChance == 2 and roll <= 20) or
		   (prideChance == 3 and roll <= 40) or
		   (prideChance == 4) then
			--print("bandit becomes prideful");
			bandit:getModData().isPrideful = true
			return true;
		else
			--print("bandit becomes not prideful");
			bandit:getModData().isPrideful = false
			return false;
		end
	end	
end

function sceneStart(bandit, requestor, anim, rbrain)
	--print("post: " .. tostring(requestor));
	bandit:getModData().previousProgram = rbrain;	--- not used atm
	bandit:getModData().sendAnim = animationPairs[anim];
	bandit:getModData().isRequestor = requestor;
	bandit:getModData().ZomboWinSexScene = true;	--off when debugging
end

--- Activates when the player clicks ask for seks on the chosen target
-- @worldobjects table of world objects nearby the player
-- @param ContextMenu object injected from ZomboWinContextMenu, can access ZomboWin functionalities with this
-- @param IsoPlayer object of the player
-- @param IsoPlayer object of the asked target
local function onAskForSex(worldobjects, contextMenu, position, requestor, target)
	local isMainHeroFemale = requestor:isFemale()
	--print("pre: " .. tostring(requestor));
	local isTargetFemale = target:isFemale()
	local isBandit = target:getVariableBoolean("Bandit");
	local sPosition = ListedPositions[position]
	local maleCount, femaleCount = 1, 1;	---override ZomboLewd's conditions
	local actorGender = "";
	if isMainHeroFemale then actorGender = "Female"; else actorGender = "Male"; end
	if target:HasTrait("dominate") or target:HasTrait("bisex") and not isMainHeroFemale then actorGender = "Male" end
	
	--- no FxF animations available ---
	if isMainHeroFemale and isTargetFemale then return; end

	local animationList = contextMenu.Client.AnimationUtils:getAnimations(2, maleCount, femaleCount, {sPosition})
	local index = ZombRand(1, #animationList + 1)
	local chosenAnimation = animationList[index]
	
	if not isBandit then
		requestor:getModData().isOffering = true;	---this method needs SERIOUS refinement, will be referenced in 'ApplyBasicTraits'
		contextMenu.Client.AnimationHandler.Play(worldobjects, {requestor, target}, chosenAnimation, true, true)
	else
		local function getPerformByGender(animation, targetGender)
			for _, actor in ipairs(animation.actors) do
				if actor.gender == targetGender then
					return actor.stages[1].perform
				end
			end
			return nil -- Return nil if no matching gender is found
		end
		
		requestor:getModData().isConsent = true;
		requestor:getModData().isOffering = true;	---this method needs SERIOUS refinement, will be referenced in 'ApplyBasicTraits'
		requestor:getModData().isPartner = target;	---this method needs SERIOUS refinement, will be referenced in 'ApplyBasicTraits'
		
		local performValue = getPerformByGender(chosenAnimation, actorGender)
		contextMenu.Client.AnimationHandler.Play(worldobjects, {requestor}, chosenAnimation, true, true)
				---need to return bandits to previous brain and program---if not bandits will stand and die...could be updated in zombie update...
		local brain = BanditBrain.Get(target)
		local rbrain = Bandit.GetProgram(target).name;
		if brain.program.name ~= "Defeat" then
			if Bandit.GetProgram(target).name ~= "Defeat" then
				Bandit.SetProgram(target, "Defeat", {});
				Bandit.SetProgramStage(target, "Subdued");
				sceneStart(target, requestor, performValue, rbrain);
			else
				Bandit.SetProgramStage(target, "Subdued");
				sceneStart(target, requestor, performValue, rbrain);
			end
		else
			Bandit.SetProgramStage(target, "Subdued");
			sceneStart(target, requestor, performValue, rbrain);
		end
	end
end

local function onDefeatForSex(worldobjects, contextMenu, position, requestor, target)
	local sPosition = ListedPositions[position]
	local maleCount, femaleCount = 1, 1;	---override ZomboLewd's conditions
	local actorGender = "";
	local isMainHeroFemale = requestor:isFemale()
	local isTargetFemale = target:isFemale()
	if isMainHeroFemale then actorGender = "Female"; else actorGender = "Male"; end
	if target:HasTrait("dominate") or target:HasTrait("bisex") and not isMainHeroFemale then actorGender = "Male" end
	local isBandit = target:getVariableBoolean("Bandit");
	
	--- no FxF animations available ---
	if isMainHeroFemale and isTargetFemale then return; end

	--- Choose random animation as a test
	local animationList = contextMenu.Client.AnimationUtils:getAnimations(2, maleCount, femaleCount, {sPosition})
	local index = ZombRand(1, #animationList + 1)
	local chosenAnimation = animationList[index]
	
	local function getPerformByGender(animation, targetGender)
		for _, actor in ipairs(animation.actors) do
			if actor.gender == targetGender then
				return actor.stages[1].perform
			end
		end
		return nil -- Return nil if no matching gender is found
	end
	
	requestor:getModData().isConsent = true;
	requestor:getModData().isPartner = target;	---this method needs SERIOUS refinement, will be referenced in 'ApplyBasicTraits'
	
	local performValue = getPerformByGender(chosenAnimation, actorGender)
	
	contextMenu.Client.AnimationHandler.Play(worldobjects, {requestor}, chosenAnimation, true, true)
	
	if isBandit then
				---need to return bandits to previous brain and program---if not bandits will stand and die...could be updated in zombie update...
		local brain = BanditBrain.Get(target)
		local rbrain = Bandit.GetProgram(target).name;
		if brain.program.name ~= "Defeat" then
			if Bandit.GetProgram(target).name ~= "Defeat" then
				Bandit.SetProgram(target, "Defeat", {});
				Bandit.SetProgramStage(target, "Subdued");
				sceneStart(target, requestor, performValue, rbrain);
			else
				Bandit.SetProgramStage(target, "Subdued");
				sceneStart(target, requestor, performValue, rbrain);
			end
		else
			Bandit.SetProgramStage(target, "Subdued");
			sceneStart(target, requestor, performValue, rbrain);
		end
	end
end


local function onSubdue(worldobjects, contextMenu, position, requestor, target)
	--HaloTextHelper.addText(requestor, getText("ContextMenu_Subdue_Yes"), HaloTextHelper.getColorGreen());
	--target:setAsSurvivor();
	target:getModData().isSubdued = true;	--- separate action will be performed to subdue.
	target:getModData().isRapist = false;	--- separate action will be performed to subdue.
	local isBandit = target:getVariableBoolean("Bandit");
	if isBandit then
		Bandit.ClearTasks(target);
        Bandit.Say(target, "DEAD");
		--target:getModData().isSubdued = true;
--[[
	elseif not isBandit then
		local brain = BanditBrain.Get(target);
		target:getModData().isFakeBandit = true;
		zwBanditize(target, brain);
]]
	end
end

local function onRelease(worldobjects, contextMenu, position, requestor, target)
	local isBandit = target:getVariableBoolean("Bandit");
	local isCruel = target:getModData().isCruel;
	local isFakeBandit = target:getModData().isFakeBandit;
	--HaloTextHelper.addText(requestor, getText("ContextMenu_Subdue_Released"), HaloTextHelper.getColorRed());
	target:getModData().isSubdued = false;
	target:setCanWalk(true);
	target:setUseless(false);
	if not target:isSitAgainstWall() and not isBandit then target:setSitAgainstWall(true); end	--- gives player time to run away!
	if isBandit and not isFakeBandit then
		--print("a bandit is released");
		local brain = BanditBrain.Get(target)		
		if brain.program.name ~= "Bandit" then
			if Bandit.GetProgram(target).name ~= "Bandit" then
				print("a bandit is set to bandit program");
				Bandit.SetProgram(target, "Bandit", {});
				Bandit.SetProgramStage(target, "Prepare");
				phrase = "reBandit";
				slayerSpeakChance(target, phrase);
			end
		end
		
		if not Bandit.IsHostile(target) then 
			
			local function makeHostile(target)
				Bandit.SetHostile(target, true); 
				Bandit.Say(target, "SPOTTED");
			end
			
			local chance = (SandboxVars.ZomboWin.banditHost);
			
			if chance == 3 or isCruel then
				makeHostile(target);
			end
			
			if chance == 2 then
				local hostile = ZombRand(2);
				if hostile == 1 then
					makeHostile(target);
				end
			end
		end 
		if Bandit.IsForceStationary(target) then Bandit.ForceStationary(target, false); end
		target:getModData().isRapist = false;
		--if not target:isSitAgainstWall() then target:setSitAgainstWall(true); end
		target:setTurnAlertedValues(-5, 5);	--- thank you Slayer!
--[[
	elseif isFakeBandit then
		target:getModData().isFakeBandit = false;
		zwZombify(target);
]]
	end
end

--- Creates a ask for seks context menu
-- @param ContextMenu object injected from ZomboWinContextMenu, can access ZomboWin functionalities with this
-- @param IsoPlayer object
-- @context Context menu object to be filled for
-- @worldobjects table of world objects nearby the player
return function(ContextMenu, playerObj, context, worldobjects)
	if not SandboxVars.ZomboWin.enableMod then return; end

	local iIndex = 0
	local bNoPants = true;
	local player = playerObj:getPlayerNum();
	SexOption = {};
	SexSubMenu = {};
	local isFemale = playerObj:isFemale()
	local restrictPants = false;
	local animationList = {};
--[[
	--- Activate native fetch function to determine if our mouse selected a square containing an IsoPlayer
	ISWorldObjectContextMenu.clearFetch()
	for _, v in ipairs(worldobjects) do
		ISWorldObjectContextMenu.fetch(v, player, true)
	end
]]
	if playerObj:isSitOnGround() then
		animationList = ContextMenu.Client.AnimationUtils:getAnimations(1, isFemale and 0 or 1, isFemale and 1 or 0, {"MastSit"})
	else
		animationList = ContextMenu.Client.AnimationUtils:getAnimations(1, isFemale and 0 or 1, isFemale and 1 or 0, {"Mast"})
	end
	
	local player = playerObj;	---redundant?
	local enemies = player:getSpottedList()
	local maxDistance = 2	--- distance to interact with bandits or zombies
	
	--playerObj	
	local stats = player:getStats()
	local bodyDamage = player:getBodyDamage()
	local unhappiness = bodyDamage:getUnhappynessLevel()
	local stress = stats:getStress();
	local panic = stats:getPanic();
	local sickness = bodyDamage:getFoodSicknessLevel()
	--local groin = bodyDamage:getBodyPart(BodyPartType.FromString("Groin")) --- if Groin:getAdditionalPain() then ? end
	local pain = stats:getPain();
	local isMainHeroFemale = player:isFemale()
	
		--- For tooltip conditions check
		local function isComfortable()
			if pain >= 10 then return false; end
			if unhappiness >= 46 then return false; end
			if panic >= 6 then return false; end
			if sickness >= 25 then return false; end
			if stress >= 25 then return false; end
			return true;
		end
		
		local function isInside()
			if player:HasTrait("Innocent") and player:isOutside() then return false; end
			return true;
		end

		local function isPrivate()
			local canSee = player:getSpottedList()
			local count = {};
			local maxDistance = 6;
			local maxWatching = 1;

			for i = 0, canSee:size() - 1 do
				local bandit = canSee:get(i)
				if bandit:isAlive() and bandit:DistTo(player) <= maxDistance then
					if bandit:getVariableBoolean("Bandit") then
						table.insert(count, bandit)
					end
				end
			end
			
			if player:HasTrait("promiscuous") or player:HasTrait("swinger") or player:HasTrait("lewd") then
				maxWatching = math.huge;
			end
			
			if #count <= maxWatching then
				return true;
			end
			
			
			return false
		end

		local function isZombieFree()
			local zombs = player:getSpottedList()
			local maxDistance = 8

			if zombs:size() > 0 then
				for i = 0, zombs:size() - 1 do
					local zambie = zombs:get(i)
					if zambie:isAlive() and zambie:isZombie() and not zambie:getVariableBoolean("Bandit") and zambie:DistTo(player) <= maxDistance then
						return false;
					end
				end
			end
			
			return true;
		end
		
		local function isFriend(bandit)
			if not bandit:getVariableBoolean("Bandit") then return false; end
			if Bandit.IsHostile(bandit) then return false; end
			
			return true
		end

		local function isNotSteppedOn(bandit)
			if bandit:isBeingSteppedOn() then 
				if bandit:isProne() or bandit:isSitAgainstWall() then
					return false; 
				end
				return true;
			end
			return true;
		end
		
		local function isSubdued(zombie)
			if zombie:getModData().isSubdued then return true; end
			return false;
		end

		local function isBandit(bandit)
			local isBandit = bandit:getVariableBoolean("Bandit");
			if isBandit then return true; end
			return false;
		end
	
	--------------------------- Main Zombo Win option ---------------------------
	SexOption = context:addOption(getText("ContextMenu_Main"), worldobjects);	
	SexSubMenu = ISContextMenu:getNew(context)	
	context:addSubMenu(SexOption, SexSubMenu)
	------------------------------------------------------------------------------

		---------------------------------- Asking for a friend ----------------------------------
		if SandboxVars.ZomboWin.allowOthers then
			--- Check if we have moused over a IsoPlayer
			
			local function playerConditions()
				if bNoPants and isComfortable() and isInside() and isPrivate() and isZombieFree() then			
					local sOption = SexSubMenu:addOption(getText("ContextMenu_AskForSex"), worldobjects)	
					local sSexSubMenu = ISContextMenu:getNew(context)	
					SexSubMenu:addSubMenu(sOption, sSexSubMenu)
					
					for iPosition = 1, #ListedPositions do	
						local text = getText(string.format("ContextMenu_AskForSex_%s", ListedPositions[iPosition]))
						if text then
							local animationOption = sSexSubMenu:addOption(text, worldobjects, onAskForSex, ContextMenu, iPosition, playerObj, clickedPlayer, function() end)
						else
							print(string.format("Missing Text: %s", anim))
						end
					end		
				elseif not bNoPants then
					local sOption = SexSubMenu:addOption(getText("ContextMenu_AskForSex"), worldobjects)		
					local tooltip = ISToolTip:new();
					tooltip:initialise();
					tooltip:setVisible(false);
					sOption.notAvailable = true;
					description = " <RED>" .. getText("ContextMenu_AskForSex_Pants");
					tooltip.description = description
					sOption.toolTip = tooltip
				elseif not isComfortable() then		
					local sOption = SexSubMenu:addOption(getText("ContextMenu_AskForSex"), worldobjects)		
					local tooltip = ISToolTip:new();
					tooltip:initialise();
					tooltip:setVisible(false);
					sOption.notAvailable = true;
					description = " <RED>" .. getText("ContextMenu_Mast_disc");
					tooltip.description = description
					sOption.toolTip = tooltip
				elseif not isInside() then		
					local sOption = SexSubMenu:addOption(getText("ContextMenu_AskForSex"), worldobjects)		
					local tooltip = ISToolTip:new();
					tooltip:initialise();
					tooltip:setVisible(false);
					sOption.notAvailable = true;
					description = " <RED>" .. getText("ContextMenu_Mast_inno");
					tooltip.description = description
					sOption.toolTip = tooltip
				elseif not isPrivate() then		
					local sOption = SexSubMenu:addOption(getText("ContextMenu_AskForSex"), worldobjects)		
					local tooltip = ISToolTip:new();
					tooltip:initialise();
					tooltip:setVisible(false);
					sOption.notAvailable = true;
					description = " <RED>" .. getText("ContextMenu_Mast_bandi");
					tooltip.description = description
					sOption.toolTip = tooltip
				elseif not isZombieFree() then		
					local sOption = SexSubMenu:addOption(getText("ContextMenu_AskForSex"), worldobjects)		
					local tooltip = ISToolTip:new();
					tooltip:initialise();
					tooltip:setVisible(false);
					sOption.notAvailable = true;
					description = " <RED>" .. getText("ContextMenu_Mast_zomb");
					tooltip.description = description
					sOption.toolTip = tooltip
				end	
			end
			
			local function banditProtocol()
				--- this method needs to follow the same condition checks as Mast.
				for i = 0, enemies:size() - 1 do
					local enemy = enemies:get(i)
					if isBandit(enemy) and enemy:DistTo(player) <= maxDistance and isFriend(enemy) and isNotSteppedOn(enemy) and not isSubdued(enemy) then
						if isBanditPrideful(enemy) then
							local sOption = SexSubMenu:addOption(getText("ContextMenu_AskForSex"), worldobjects)	
							local sSexSubMenu = ISContextMenu:getNew(context)	
							SexSubMenu:addSubMenu(sOption, sSexSubMenu)
							
							for iPosition = 1, #ListedPositions do	
								local text = getText(string.format("ContextMenu_AskForSex_%s", ListedPositions[iPosition]))
								if text then
									local animationOption = sSexSubMenu:addOption(text, worldobjects, onAskForSex, ContextMenu, iPosition, playerObj, enemy, function() end)
								else
									print(string.format("Missing Text: %s", anim))
								end
							end	
						else
							--- return not gay
							local sOption = SexSubMenu:addOption(getText("ContextMenu_AskForSex"), worldobjects)		
							local tooltip = ISToolTip:new();
							tooltip:initialise();
							tooltip:setVisible(false);
							sOption.notAvailable = true;
							description = " <RED>" .. getText("ContextMenu_AskForSex_notPride");
							tooltip.description = description
							sOption.toolTip = tooltip
						end
					end
				end
			end
			
			if clickedPlayer then	-- only workes for others, not yourself... currently NOT working.
				--print("isoplayer detected");
				local pp = getPlayer();
				if pp ~= clickedPlayer then ----- this will differentiate clicking self or clicking another player -----
					--print("non player iso detected");
					-- This will check other persons clothing.
					local iTheirClothes = clickedPlayer:getWornItems()
					if iTheirClothes then
					--- Loop through the character's currently equipped items for pants
						for i = iTheirClothes:size(), 1, -1 do
							local wornItem = iTheirClothes:get(i - 1) --- Get the current worn item

							if wornItem then
								local item = wornItem:getItem() --- Receive item data
								local location = wornItem:getLocation() --- Receive location of where this item is located on the body
								if item:IsClothing() then --- Make sure it is a clothing piece
									--- Iterate through the pants clothing list
									local isWearingPants = false
									
									for v = 1, #clothingHandler.checkPants do
										if bNoPants then
											local bodyPart = clothingHandler.checkPants[v]

											if location == bodyPart then
												bNoPants = false;
												isWearingPants = true;
											end
										end
									end
									
									if isWearingPants then
										break;
									end
								end
							end
						end
						playerConditions();
					end
				end
			else
				banditProtocol();
			end
		end
		-----------------------------------------------------------------------------------------

	---------------------------------- Mast ----------------------------------
	if not isComfortable() or not isInside() or not isPrivate() or not isZombieFree() or SandboxVars.ZomboWin.restrictPants and isWearingPants() then
		local masturbateOption = SexSubMenu:addOption(getText("ContextMenu_Masturbate"), worldobjects)
		local tooltip = ISToolTip:new();
		tooltip:initialise();
		tooltip:setVisible(false);
		masturbateOption.notAvailable = true;
		if not isComfortable() then 
			description = " <RED>" .. getText("ContextMenu_Mast_disc");
			tooltip.description = description;
			masturbateOption.toolTip = tooltip;
		elseif not isInside() then
			description = " <RED>" .. getText("ContextMenu_Mast_inno");
			tooltip.description = description;
			masturbateOption.toolTip = tooltip;
		elseif not isPrivate() then
			description = " <RED>" .. getText("ContextMenu_Mast_bandi");
			tooltip.description = description;
			masturbateOption.toolTip = tooltip;
		elseif not isZombieFree() then
			description = " <RED>" .. getText("ContextMenu_Mast_zomb");
			tooltip.description = description;
			masturbateOption.toolTip = tooltip;
		elseif SandboxVars.ZomboWin.restrictPants and isWearingPants() then
			description = " <RED>" .. getText("ContextMenu_Mast_pants");
			tooltip.description = description;
			masturbateOption.toolTip = tooltip;
			restrictPants = true;
		end
	end
--[[	--- combined with above
	if SandboxVars.ZomboWin.restrictPants and isWearingPants() then
		local masturbateOption = SexSubMenu:addOption(getText("ContextMenu_Masturbate"), worldobjects)
		local tooltip = ISToolTip:new();
		tooltip:initialise();
		tooltip:setVisible(false);
		masturbateOption.notAvailable = true;
		description = " <RED>" .. getText("ContextMenu_Mast_pants");
		tooltip.description = description;
		masturbateOption.toolTip = tooltip;
		restrictPants = true;
	end
]]
	if isComfortable() and isInside() and isPrivate() and isZombieFree() and not restrictPants then
		local masturbateOption = SexSubMenu:addOption(getText("ContextMenu_Masturbate"), worldobjects)
		local masturbationSubMenu = ISContextMenu:getNew(context)
		SexSubMenu:addSubMenu(masturbateOption, masturbationSubMenu)
		
		for i = 1, #animationList do
			local animation = animationList[i]
			local contextMenu_translate_text = string.format("ContextMenu_%s%s", animation.prefix, animation.id)
			local text = getText(contextMenu_translate_text)
			
			if text then
				--- Create a new tooltip when the player hovers over the sub option
				local toolTip = ISToolTip:new()
				toolTip.description = "" --- Make tooltip description in the future
				toolTip:setName(text)
				toolTip:initialise()
				toolTip:setVisible(false)

				--- Create the new sub option...emotional block here...before addoption w/ function
				local animationOption = {masturbationSubMenu:addOption(text, worldobjects, ContextMenu.Client.AnimationHandler.Play, {playerObj}, animation), function() end}
				animationOption.toolTip = toolTip
			else
				print(string.format("Missing Text: %s", contextMenu_translate_text))
			end
		end
	end
	--------------------------------------------------------------------------

		---------------------------------- Down Manip: Requires isSubdued ----------------------------------
		for i = 0, enemies:size() - 1 do
			local enemy = enemies:get(i)
			local isBandit = enemy:getVariableBoolean("Bandit");
			------------------------------------------> For: Subduing Zombies and Bandits ------------------------------------------>
			if enemy:isZombie() and enemy:DistTo(player) <= maxDistance and enemy:isBeingSteppedOn() and not enemy:getModData().isSubdued then
				----- Check for Rope -----
				local weapon = player:getPrimaryHandItem()
				if weapon == nil then 
					local dOption = SexSubMenu:addOption(getText("ContextMenu_Subdue"), worldobjects);	
					local tooltip = ISToolTip:new();
					tooltip:initialise();
					tooltip:setVisible(false);
					dOption.notAvailable = true;
					description = " <RED>" .. getText("ContextMenu_Subdue_noRope");
					tooltip.description = description;
					dOption.toolTip = tooltip;
					break; 
				end
				if not weapon:hasTag("Rope") then 
					local dOption = SexSubMenu:addOption(getText("ContextMenu_Subdue"), worldobjects);	
					local tooltip = ISToolTip:new();
					tooltip:initialise();
					tooltip:setVisible(false);
					dOption.notAvailable = true;
					description = " <RED>" .. getText("ContextMenu_Subdue_noRope");
					tooltip.description = description;
					dOption.toolTip = tooltip;
				elseif weapon:hasTag("Rope") then
					local text = getText(string.format("ContextMenu_Subdue"))
					if text then	
						--- Create the new sub option onAskForSex(worldobjects, contextMenu, position ,requestor, target)
						local dOption = SexSubMenu:addOption(text, worldobjects, onSubdue, ContextMenu, iPosition, playerObj, enemy, function() end)
					else
						print(string.format("Missing Text: %s", anim))
					end
				end
		------------------------------------------> For: Grape or Release Zombies ------------------------------------------>
--[[			DISABLED: Player -Defeat-> Zombies not implemented yet!
			elseif enemy:isZombie() and enemy:DistTo(player) <= maxDistance and not isBandit and enemy:getModData().isSubdued then
				if not isPanickedCheck() then
					local dSexSubMenu = ISContextMenu:getNew(context);
					--- Release menu option
					local text = getText(string.format("ContextMenu_Release"))
					if text then	
						--- Create the new sub option onAskForSex(worldobjects, contextMenu, position ,requestor, target)
						local dOption = SexSubMenu:addOption(text, worldobjects, onRelease, ContextMenu, iPosition, playerObj, enemy)
					else
						print(string.format("Missing Text: %s", anim))
					end
					--- end
					if enemy:getModData().isSubdued then	---previously had "condition: enemy:isUseless()" but Bandits mod overrides isUseless()
						if not player:HasTrait("Innocent") then
							if not enemy:isBeingSteppedOn() then
								local dOption = SexSubMenu:addOption(getText("ContextMenu_DefeatForSex"), worldobjects)	
								SexSubMenu:addSubMenu(dOption, dSexSubMenu);
								for iPosition = 1, #ListedPositions do	
									local text = getText(string.format("ContextMenu_DefeatForSex_%s", ListedPositions[iPosition]))
									if text then	
										--- Create the new sub option onAskForSex(worldobjects, contextMenu, position ,requestor, target)
										local animationOption = dSexSubMenu:addOption(text, worldobjects, onDefeatForSex, ContextMenu, iPosition, playerObj, enemy)
									else
										print(string.format("Missing Text: %s", anim))
									end
								end	
							else
								dOption = SexSubMenu:addOption(getText("ContextMenu_DefeatForSex"), worldobjects);	
								local tooltip = ISToolTip:new();
								tooltip:initialise();
								tooltip:setVisible(false);
								dOption.notAvailable = true;
								description = " <RED>" .. getText("ContextMenu_DefeatError_Standing");
								tooltip.description = description;
								dOption.toolTip = tooltip;
								break;
							end
						else
							local dOption = SexSubMenu:addOption(getText("ContextMenu_DefeatForSex"), worldobjects);	
							local tooltip = ISToolTip:new();
							tooltip:initialise();
							tooltip:setVisible(false);
							dOption.notAvailable = true;
							description = " <RED>" .. getText("ContextMenu_DefeatForSex_Inno");
							tooltip.description = description;
							dOption.toolTip = tooltip;
							break; 
						end
					end
				elseif isPanickedCheck() then
					dOption = SexSubMenu:addOption(getText("ContextMenu_DefeatForSex"), worldobjects);	
					local tooltip = ISToolTip:new();
					tooltip:initialise();
					tooltip:setVisible(false);
					dOption.notAvailable = true;
					description = " <RED>" .. getText("ContextMenu_DefeatForSex_Panic");
					tooltip.description = description;
					dOption.toolTip = tooltip;
					break;
				end
]]
		------------------------------------------> For: Grape or Release Bandits ------------------------------------------>
			elseif enemy:isZombie() and enemy:DistTo(player) <= maxDistance and isBandit and not Bandit.IsHostile(enemy) and enemy:getModData().isSubdued then
				if not isPanickedCheck() then
					---------------------------------------- Release menu option ----------------------------------------
					local text = getText(string.format("ContextMenu_Release"))
					if text then	
						--- Create the new sub option onAskForSex(worldobjects, contextMenu, position ,requestor, target)
						local dOption = SexSubMenu:addOption(text, worldobjects, onRelease, ContextMenu, iPosition, playerObj, enemy, function() end)
					else
						print(string.format("Missing Text: %s", anim))
					end
					----------------------------------------------- end --------------------------------------------------
					if not enemy:isBeingSteppedOn() then
						local sOption = SexSubMenu:addOption(getText("ContextMenu_DefeatForSex"), worldobjects)	
						local sSexSubMenu = ISContextMenu:getNew(context);
						SexSubMenu:addSubMenu(sOption, sSexSubMenu);
						
						for iPosition = 1, #ListedPositions do	
							local text = getText(string.format("ContextMenu_DefeatForSex_%s", ListedPositions[iPosition]))
							if text then	
								--- Create the new sub option onAskForSex(worldobjects, contextMenu, position ,requestor, target)
								local animationOption = sSexSubMenu:addOption(text, worldobjects, onDefeatForSex, ContextMenu, iPosition, playerObj, enemy, function() end)
							else
								print(string.format("Missing Text: %s", anim))
							end
						end	
					else
						dOption = SexSubMenu:addOption(getText("ContextMenu_DefeatForSex"), worldobjects);	
						local tooltip = ISToolTip:new();
						tooltip:initialise();
						tooltip:setVisible(false);
						dOption.notAvailable = true;
						description = " <RED>" .. getText("ContextMenu_DefeatError_Standing");
						tooltip.description = description;
						dOption.toolTip = tooltip;
						break;
					end
				elseif isPanickedCheck() then
					dOption = SexSubMenu:addOption(getText("ContextMenu_DefeatForSex"), worldobjects);	
					local tooltip = ISToolTip:new();
					tooltip:initialise();
					tooltip:setVisible(false);
					dOption.notAvailable = true;
					description = " <RED>" .. getText("ContextMenu_DefeatForSex_Panic");
					tooltip.description = description;
					dOption.toolTip = tooltip;
					break;
				end
			end
		end
		----------------------------------------------------------------------------------------------------

end
